<?php

namespace app\components\rbac\rules;

use app\components\User;
use yii;
use yii\rbac\Rule;

/**
 * Verifies if resource author/owner matches current user
 */
class AuthorRule extends Rule
{

    public $name = 'isAuthor';

    /**
     * @param string|integer $user the user ID.
     * @param yii\rbac\Item $item the role or permission that this rule is associated with
     * @param array $params parameters passed to ManagerInterface::checkAccess().
     * @return boolean a value indicating whether the rule permits the role or permission it is associated with.
     */
    public function execute($user, $item, $params)
    {
        if (isset($params['listing']) && $params['listing']) {
            // Used by Data Providers to filter a collection
            return true;
        } elseif (isset($params['model'])) {
            $model = $params['model'];
            return isset($model->created_by) ? $model->created_by == $user : false;
        } elseif (isset($params['ids'], $params['query'], $params['columnName'])) {
            /** @var User $user */
            $user = Yii::$app->user;
            $ownIds = $user->getOwnModelIds($params['query'], $params['columnName']);
            foreach ($params['ids'] as $id) {
                if (!in_array($id, $ownIds)) {
                    return false;
                }
            }
            return true;
        }
        // Denied access by default
        return false;
    }
}
